#define USEFOG

float4x4 viewProjMatrix : register (c0);
float4x4 worldMatrix : register (c4);
float4 worldEye : register (c8);
float4 fogData : register (c9);
float4 ambBase : register (c12);
float4 dirBase : register (c13);
float4 dirLight : register (c14);
float4 specLight : register (c15);

#if OMNI == 1

float4 omniPosRad[12]   : register (c72);
float4 omniRGBDelta[12] : register (c84);

#elif SPOT == 1

float4 spotPosRad[4]    : register (c72);
float4 spotRGBDelta[4]  : register (c80);
float4 spotDirCone[4]   : register (c88);

#endif

struct VS_OUTPUT
{
   float4 Pos  : POSITION;
   float4 Diff : COLOR0;
   float4 Spec : COLOR1;
#ifdef USEFOG
   float  Fog  : FOG;
#endif   
#if NUMTEX == 1
   float2 Tex0 : TEXCOORD0;
   float3 Cube : TEXCOORD1;
#elif NUMTEX == 2
   float2 Tex0 : TEXCOORD0;
   float2 Tex1 : TEXCOORD1;
#endif
};

#if OMNI == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_gouraudCmapSpecMapOmniT0  (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_gouraudCmapSpecMapOmniT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #endif
  
#elif SPOT == 1

 #if NUMTEX == 1
  VS_OUTPUT vs11_gouraudCmapSpecMapSpotT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_gouraudCmapSpecMapSpotT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #endif
  
#else

 #if NUMTEX == 1
  VS_OUTPUT vs11_gouraudCmapSpecMapT0 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0)
 #elif NUMTEX == 2
  VS_OUTPUT vs11_gouraudCmapSpecMapT0T1 (float4 inPos : POSITION, float4 inNorm : NORMAL, float4 inColor : COLOR0, float2 inTex0 : TEXCOORD0, float2 inTex1 : TEXCOORD1)
 #endif
  
#endif
{
  VS_OUTPUT Out;
  
  // Transform vertex position into view space:
  Out.Pos = mul (viewProjMatrix, inPos);
  
  float4 worldNorm = mul (worldMatrix, inNorm.xyz);
  float magLight = saturate (dot (worldNorm, dirLight));
  Out.Diff = (dirBase * magLight) + ambBase;

  // compute specular here
  float3 worldPos = mul (worldMatrix, inPos);
  float3 eyeVec =  worldEye.xyz + worldPos.xyz;
#if OMNI == 0 && SPOT == 0
  Out.Spec = pow (saturate (dot (normalize (dirLight.xyz - normalize (eyeVec.xyz)), worldNorm.xyz)), specLight.a) * specLight;
#else  
  Out.Spec = 0;
#endif  

  // compute reflection: E - 2(E dot N)N
  float EdotN = 2.0 * dot (worldNorm.xyz, eyeVec);
  Out.Cube = eyeVec - (EdotN * worldNorm);
  
#ifdef USEFOG
  // compute fog
  Out.Fog.x = (fogData[1] - (length (eyeVec.xyz) * fogData[0]));
#endif   
  
#if OMNI == 1
  // Compute omnilights
  float4 omni={0,0,0,0};
  for (int i=0; i<7; i++)
  {
    float intens;
    float3 omniToVert = omniPosRad[i].xyz - worldPos.xyz;
    float mag = dot (omniToVert.xyz, omniToVert.xyz);
    // check if vert in range
    if ( mag < omniPosRad[i].w) // using square distances
      if ((intens = dot (worldNorm, normalize (omniToVert))) > 0) // check backface
        omni.rgb += (intens * omniRGBDelta[i].rgb * (1.0F - (sqrt(mag) * omniRGBDelta[i].w)));
  }
  Out.Diff.rgb += omni;// - (dirBase + ambBase);
  Out.Diff.a = inColor.a;

#elif SPOT == 1  
#endif

  Out.Tex0 = inTex0;
#if NUMTEX > 1
  Out.Tex1 = inTex1;
#endif  
  return (Out);
}

